<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
require dirname(__FILE__).('/FirePHPCore/FirePHP.class.php');
/*
############
############ Using FirePHP on production sites can expose sensitive information ###########
############
*/
/**
 * 
 * Magix cjQuery
 * 
 * @author Gérits Aurélien
 * @copyright Magix cjQuery
 * @version 0.2
 * @package debug with FirePHP
 * FirePHP (false or true)
 * define('M_FIREPHP',true);
 *
 */
class magixcjquery_debug_magixfire{
	/**
	 * Instance FirePHP class
	 * @var Instance
	 * @access protected
	 * @static
	 */
  protected static $Instance;
	/**
	* timer start
	* @var timerStart
	*/
  protected static $timerStart = 0;
  /**
   * timer stop
   * @var timerEnd
   */
  protected static $timerEnd = 0;
  /**
   * @static function Instance
   * Singleton function
   */
  protected static function Instance(){
  		if (!isset(self::$Instance)){
         	self::$Instance = new FirePHP();
        }
    return self::$Instance;
  }
  /*
   * get Instance FirePHP and execute if M_FIREPHP = true
   */
	protected static function getIniInstance(){
	    if (M_FIREPHP){
	    	$firephp = self::Instance()->getInstance(true);
	    }else{
	    	$firephp = self::Instance()->getInstance(false);
	    }
	    return $firephp;
	}
	protected function is_assoc($array) {
    	return (is_array($array) && 0 !== count(array_diff_key($array, array_keys(array_keys($array)))));
  	}
	/**
	 * function configErrorHandler
	 * Ini send Convert E_WARNING, E_NOTICE, E_USER_ERROR, E_USER_WARNING, E_USER_NOTICE 
	 * and E_RECOVERABLE_ERROR to Firebug automatically.
	 * exemple in config application :
	 * magixcjquery_debug_firephp::configErrorHandler();
	 * try {
	 * throw new Exception('Test Exception');
	 * catch(Exception $e) {
	        magixcjquery_debug_magixfire::magixFireError($e);
		}
	 * 
	 */
  	public static function configErrorHandler(){
  		if (M_FIREPHP){
  			// converts errors into exceptions
  			self::Instance()->registerErrorHandler($throwErrorExceptions=true);
  			// makes FirePHP handle exceptions and sends it to FirePHP
  			self::Instance()->registerExceptionHandler();
  			self::Instance()->registerAssertionHandler($convertAssertionErrorsToExceptions=true,$throwAssertionExceptions=false);
  		}
  	}
  	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
  	public static function magixFireLog($object,$label=false){
  		if(self::getIniInstance()){
  			return self::Instance()->log($object,$label);
  		}
  	}
	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
	public static function magixFireInfo($object,$label=false){
  		if(self::getIniInstance()){
  			return self::Instance()->info($object,$label);
  		}
  	}
	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
	public static function magixFireError($object,$label=false){
  		if(self::getIniInstance()){
  			return self::Instance()->error($object,$label);
  		}
  	}
	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
	public static function magixFireWarn($object,$label=false){
  		if(self::getIniInstance()){
  			return self::Instance()->warn($object,$label);
  		}
  	}
	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
	public static function magixFireGroup($object,$label=false){
  		if(self::getIniInstance()){
  			return self::Instance()->group($object,$label);
  		}
  	}
  	/**
  	 * function groupEnd in FirePHP
  	 */
	public static function magixFireGroupEnd(){
  		if(self::getIniInstance()){
  			return self::Instance()->groupEnd();
  		}
  	}
	/**
  	 * 
  	 * @param void $object
  	 * @param void $label
  	 */
	public static function magixFireDump($object,$vars,$label=false){
  		if(self::getIniInstance()){
  			if (!is_array($vars)) {
  				$dump = self::magixFireLog("vardump: ".$object.'=>'.$vars,$label);
  			}else {
	          if (self::is_assoc($vars)) {
	            $dump = self::magixFireGroup("vardump: ".$object." (associative array)");
	            $dump .= self::magixFireLog("(");
	            foreach($vars as $var=>$value) {
	              $dump .= self::magixFireLog("['".$var."'] => ".$value);
	            }
	          } else {
	            $dump =self::magixFireGroup("vardump: ".$object." (associative array)");
	            $dump .= self::magixFireLog("(");
	            foreach($vars as $var) {
	              $dump .= self::magixFireLog($var);
	            }
	          }
	          $dump .=self::magixFireLog(")");
	          $dump .=self::magixFireGroupEnd();
	        }
  		}
  		return $dump;
  	}
	/**
	   * start microtime execute 
	   */
	  protected static function timeStart(){
	  	if(self::getIniInstance()){
		    self::$timerStart = microtime();
		    self::$timerEnd = 0;
	  	}
	  }
	  /**
	   * stop microtime execute 
	   */
	  protected static function timeStop(){
	  	if(self::getIniInstance()){
	    	self::$timerEnd =microtime();
	  	}
	  }
  	/**
  	 * ini Timerstart function
  	 */
  	public static function MagixTimerStart(){
  		if(self::getIniInstance()){
  			return self::timeStart();
  		}
  	}
  	/**
  	 * ini Timerstop function
  	 */
	public static function MagixTimerStop(){
		if(self::getIniInstance()){
  			return self::timeStop();
		}
  	}
	/**
	 * return calculation for execute start and stop
	 */
	  protected static function getResultCalculation(){
	    if(self::$timerEnd == 0) self::MagixTimerStop();
	      return self::$timerEnd - self::$timerStart;
	  }
  	/**
  	 * return result where Timerget 
  	 */
  	public static function MagixTimerResult(){
  		return self::magixFireLog("execution time :". self::getResultCalculation() . ' seconds');
  	}
}
?>