<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * 
 * 
 * @author Gérits Aurélien
 * @package magixpacker
 * @access public
 * @copyright magix cjQuery
 * @version 0.1
 *
 */
require('class.JavaScriptPacker.php');
class magixcjquery_jquery_packer_pack{
	/**
	 * calculate time start
	 *
	 * @return void
	 */
	public static function timeStart(){
		return microtime(true);
	}
	/**
	 * calculate time end
	 *
	 * @return void
	 */
	public static function timeEnd(){
		return microtime(true);
	}
	/**
	 * function ini packer
	 *
	 * @param $script
	 * @param numeric $_encoding
	 * @param $_fastDecode
	 * @param $_specialChars
	 * @return void
	 */
	public static function packer($script,$_encoding='62',$_fastDecode=true,$_specialChars=false){
		  $packer = new JavaScriptPacker($script);
		  $packed = $packer->pack();
		  return $packed;
	}
	/**
	 * ratio
	 *
	 * @param void $script
	 * @param void $packed
	 * @return string
	 */
	public static function ratio($script,$packed){
		$originalLength = strlen($script);
		$packedLength = strlen($packed);
		return number_format($packedLength / $originalLength, 3);
	}
	/**
	 * calculate time exec
	 *
	 * @param void $script
	 * @param void $packed
	 * @return void
	 */
	public static function time($t1,$t2){
		return sprintf('%.4f', ($t2 - $t1) );
	}
}
?>