<?php 
class dbConstruct{
	protected $tables = array();
	protected $prefix;
	private static $instance = null;
	/**
  * Instance de la classe PDO
  *
  * @var PDO
  * @access private
  */
	private $PDOInstance = null;
	 /**
  * Instance DataObjects class
  *
  * @var DataObjects
  * @access private
  * @static
  */
	private $execute; 
	
      
    public function __construct () 
    {
    	$dbInfo = new CallDbData();
    	if (!($dbInfo instanceof CallDbData)) {
    		throw new Exception('Invalid instanceof');
    	}
        try 
        {
			$this->PDOInstance = new PDO($dbInfo->getconnStr(),$dbInfo->getuser(),$dbInfo->getpass());
			$this->PDOInstance->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
        catch(PDOException $e){
        	echo $e->getMessage();
		}
    }
    private static function getInstance(){
    	
    	if(is_null(self::$instance))
		{
			self::$instance = new DataObjects();
		}
		return self::$instance;
    }
	/**
	 * instance exec
	 *
	 * @param void $sql
	 */
	function exec($sql){
		$this->PDOInstance->exec($sql);
	}
	/**
	 * ini create table
	 *
	 * @param unknown_type $name
	 * @return unknown
	 */
	function table($name){
		$table = 'CREATE TABLE IF NOT EXISTS '.$name.' (';
		$table .= $this->params.' )';
		return self::exec($table);
	}
	function params($params){
		return $this->params($params);
	}
}
class dbStructure{
	/**
	Universal data types supported by dbconstruct
	
	SMALLINT	: signed 2 bytes integer
	INTEGER	: signed 4 bytes integer
	BIGINT	: signed 8 bytes integer
	REAL		: signed 4 bytes floating point number
	FLOAT	: signed 8 bytes floating point number
	NUMERIC	: exact numeric type
	
	DATE		: Calendar date (day, month and year)
	TIME		: Time of day
	TIMESTAMP	: Date and time
	
	CHAR		: A fixed n-length character string
	VARCHAR	: A variable length character string
	TEXT		: A variable length of text
	*/
	protected $allowed_types = array(
		'smallint','integer','bigint','real','float','numeric',
		'date','time','timestamp',
		'char','varchar','text'
	);
}