<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------

/**
 * @link http://www.clashdesign.be
 * @copyright clashdesign.be 2009
 * @author : Gérits Aurélien
 * @package : pagination
 * @version 0.1
 * 
 *
 */
class magixcjquery_pager_pagination{
		/**
		 * @calculate page offset
		 *
		 * @param int $limit
		 * @param object $page
		 * @return int
		 */
	  function pageOffset($limit=10,$getpage){
	  	return $limit * (abs($getpage)-1);
	  }
	    /**
		 * @calculate paging information
		 *
		 * @access
		 *
		 * @param void $request
		 *
		 * @param int $limit
		 *
		 * @param object $page
		 *
		 * @return object
		 *
		**/
	  function pagerData($request,$as,$limit=10,$getpage,$url=false,$host=false,$rewrite=false,$namepage=null,$debug=false){
	  	$num = '';
	  	foreach ($request as $t) $num_pages = $t[$as];
	  	$num_pages = ceil($num_pages/$limit);
	  	$page = max($getpage, 1);
    	$page = min($getpage, $num_pages);
		if($getpage > $limit || $getpage <= 0) {
			$page = 1;
		}
		$debug?self::debugPager($page,$num_pages,$limit,$getpage):false;
		$offset = $getpage;
		if($offset > $num_pages)
		{
		  $offset = $num_pages;
		}
	    $offset = $this->pageOffset($limit,$getpage);
	    if ($rewrite == false) {
	    	$rewrite = 'page=';
	    }else{
	    	$rewrite = $namepage.'/';
	    }
	    if($getpage > 1)
		    {
		    	$num .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$url.$rewrite.(min($getpage, 1)).$host.'">&#171;&#171;</a>';
		        $num .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$url.$rewrite.($getpage - 1).$host.'">&#171;</a>';
		    }
	    if($num_pages>1){
			for($i=1; $i<=$num_pages; $i++){
				if($i==$getpage){
				   $num .= '<span class="current">'.$i.'</span>'; 
				}else{
				  $num .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$url.$rewrite.$i.$host.'">'.$i.'</a>';  
				}
			}
		}
		if ($getpage < $num_pages)  {
		    $num .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$url.$rewrite.($getpage + 1).$host.'">&#187;</a>';
		    $num .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$url.$rewrite.max($getpage, $num_pages).$host.'">&#187;&#187;</a>';
		}
		return $num;
	  }
	  /**
	   * function debug pagination
	   *
	   * @param void $page
	   * @param void $num_pages
	   * @param int $limit
	   * @param void $getpage
	   */
	  function debugPager($page,$num_pages,$limit,$getpage){
	  	/*debug*/
		print 'Page : '.$page.'<br />Num_Pages : '.$num_pages.'<br />Limit : '.$limit.'##########<br />';
		$page = max($getpage, 1);
		print 'Page : '.$page.'<br />Num_Pages : '.$num_pages.'<br />Limit : '.$limit.'##########<br />';
		$page = min($getpage, $num_pages);
		print 'Page : '.$page.'<br />Num_Pages : '.$num_pages.'<br />Limit : '.$limit.'##########<br />';
				if($getpage > $limit || $getpage <= 0) {
					$page = 1;
				}
		print 'Page : '.$page.'<br />Num_Pages : '.$num_pages.'<br />Limit : '.$limit.'##########<br />';
	  }
	  /**
	   * class pagination FirstString
	   *
	   * @param first letters $firstlt
	   * @param sql $request
	   * @param $key
	   * @param string $url
	   * @return void
	   */
	function pagerString($firstlt,$request,$key,$rewrite='current',$url=false){
		$lt_tampon = -1;
		$lt = null;
		//$rewrite = $url ? $url.$key.'/' : '?'.$key.'=';
		if ($rewrite == 'rewrite') {
			$urlreq = $_SERVER['PHP_SELF'];
			$point = strpos($urlreq,'.');
			$subst = substr($urlreq, 0, $point);
			$rewrite = $subst.'/'.$url.'/'.$key.'/';
		}elseif($rewrite == 'current'){
			$rewrite = $_SERVER['PHP_SELF'].'?'.$url.'=';
		}
		foreach($request as $l){
				$let = $l[$key];
				if ($let == $firstlt){
					$lt .= '<span class="current">'.magixcjquery_string_convert::upTextCase($firstlt).'</span>';
				}else{
					$lt .= '<a href="'.magixcjquery_html_helpersHtml::getUrl().$rewrite.$let.'">'.magixcjquery_string_convert::upTextCase($l[$key]).'</a>';
				}
				//letters prev diff letters next
				if ($lt!= $lt_tampon)
				{
					// Save new letters
					$lt_tampon .= $lt;
				}
		}
		return $lt;
	}
} /*** end of class ***/
?>