<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * 
 * Magix RSS
 * 
 * @author Gérits Aurélien
 * @access public
 * @copyright clashdesign
 * @version 0.1
 * @package Create RSS XML
 *
 */
class magixcjquery_xml_rss{
	/**
	 * 
	 * @var instance XML WRITER
	 */
	protected $writer;
	/**
	 * url valid sitemap standard
	 * @var NS string
	 */
	protected $NS = 'http://purl.org/dc/elements/1.1/';
	protected $ATOM = 'http://www.w3.org/2005/Atom';
	/**
	 * Cinstruc class
	 * @return
	 */
	function __construct(){
		$this->writer = magixcjquery_xml_xml::xmlInstance()->xmlWriter;
	}
	/**
	 * Create XML File implement createFile
	 * @param $file (string)
	 * @return void
	 */
	function createRSS($file){
		magixcjquery_xml_xml::xmlInstance()->createFile($file);
	}
	/**
	 * Open File and Create new xmlwriter using source uri for output (implement openUrilXml)
	 * @param $file (string)
	 * @return void
	 */
	function openFileRSS($file){
		magixcjquery_xml_xml::xmlInstance()->openUriXml($file);
	}
/**
	 * Toggle indentation on/off (implement indent)
	 * @param $indent = true/false
	 * @return void
	 */
	function indentRSS($indent=true){
		magixcjquery_xml_xml::xmlInstance()->indent($indent);
	}
	/**
	 * Start write head in XML file
	 * @param $encode
	 * @return void
	 */
	function startWriteRSS($encode="UTF-8"){
		$date = new DateTime(date('c'));
		$this->writer->startDocument('1.0', $encode);
		$this->writer->writeComment('Generated by magix cjQuery Framework');
		$this->writer->startElement ('rss'); // [1] First Node
		$this->writer->writeAttribute('version' , '2.0');
		$this->writer->writeAttribute('xmlns:atom' , $this->ATOM)."\n";
		$this->writer->writeAttribute('xmlns:dc' , $this->NS);
		$this->writer->startElement('atom:link');
		$this->writer->writeAttribute('href',magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().'rss.xml');
		$this->writer->writeAttribute('rel','self');
		$this->writer->writeAttribute('type','application/rss+xml');
		$this->writer->endElement();
		$this->writer->startElement ('channel'); // [2] Second Node
		$this->writer->writeElement('title' , substr(magixcjquery_html_helpersHtml::getUrl(),-16));
		$this->writer->writeElement('lastBuildDate' , $date->format(DATE_RFC2822));
		$this->writer->writeElement('link' , magixcjquery_html_helpersHtml::getUrl().'/rss.xml');
		$this->writer->writeElement('description' , 'Le fil RSS '.substr(magixcjquery_html_helpersHtml::getUrl(),-16).' pour être informer au quotidien');
	}
	/**
	 * Start write head in  ATOM XML file
	 * @param $encode
	 * @return void
	 */
	function startWriteAtom($encode="utf-8",$lang="fr",$name=null,$email=null){
		$this->writer->startDocument('1.0', $encode);
		//$this->writer->startElement ('rss'); // [1] First Node
		$this->writer->startElement ('feed'); // [1] First Node
		$this->writer->writeAttribute('version' , '2.0');
		$this->writer->writeAttribute('xmlns:atom' , $this->ATOM)."\n";
		$this->writer->writeAttribute('xmlns:dc' , $this->NS)."\n";
		/*$this->writer->writeAttribute('xmlns:wfw' , "http://wellformedweb.org/CommentAPI/")."\n";
		$this->writer->writeAttribute('xml:lang' , $lang);*/
		/*$this->writer->startElement('atom:link');
		$this->writer->writeAttribute('href',magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().'rss.xml');
		$this->writer->writeAttribute('rel','self');
		$this->writer->writeAttribute('type','application/rss+xml');
		$this->writer->endElement();*/
		$this->writer->startElement('title');
		$this->writer->writeAttribute('type','html');
		$this->writer->text(magixcjquery_html_helpersHtml::getUrl());
		$this->writer->endElement();
		$this->writer->startElement('link');
		$this->writer->writeAttribute('href',magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().'rss.xml');
		$this->writer->writeAttribute('rel','alternate');
		$this->writer->writeAttribute('type','application/atom+xml');
		$this->writer->endElement();
		$this->writer->writeElement('updated' , date('c'));
		$this->writer->writeElement('id' , magixcjquery_html_helpersHtml::getUrl());
		$this->writer->startElement('generator');
		$this->writer->writeAttribute('uri' , "http://magix-cjquery.com");
		$this->writer->text("Generated by magix cjQuery Framework");
		$this->writer->endElement();
		$this->writer->startElement('author');
		$this->writer->writeElement('name' , $name);
		//$this->writer->writeElement('email' , $email);
		$this->writer->endElement();
	}
	/**
	 * create childnode url from parent urlset
	 * @param $encode
	 * @return void
	 */
	function elementWriteRSS($title,$pubDate,$url,$ext,$texte=false){
		$date = new DateTime($pubDate);
		$this->writer->startElement('item');// [2] Second Node
		$this->writer->writeElement('guid',magixcjquery_filter_isVar::isURL(magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().$url.magixcjquery_html_helpersHtml::unixSeparator().str_replace('-','/',$pubDate).magixcjquery_html_helpersHtml::unixSeparator().$title.$ext));
		$this->writer->writeElement('title',str_replace('-',' ',$title));
		$this->writer->writeElement('pubDate',$date->format(DATE_RFC2822));
		$this->writer->writeElement('link',magixcjquery_filter_isVar::isURL(magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().$url.magixcjquery_html_helpersHtml::unixSeparator().str_replace('-','/',$pubDate).magixcjquery_html_helpersHtml::unixSeparator().$title.$ext));
		$this->writer->startElement('description');
		// Section CDATA
		$this->writer->writeCdata($texte ? $texte : false);
		//Close elements
		$this->writer->endElement();
		$this->writer->endElement();
	}
/**
	 * create childnode url from parent urlset
	 * @param $encode
	 * @return void
	 */
	function elementWriteAtom($title,$update,$identifier,$ext,$content){
		$date = new DateTime($update);
		$this->writer->startElement('entry');// [2] Second Node
		$this->writer->writeElement('title',str_replace('-',' ',$title));
		$this->writer->writeElement('update',$date->format(DATE_ATOM));
		$this->writer->writeElement('id',magixcjquery_filter_isVar::isURL(magixcjquery_html_helpersHtml::getUrl().magixcjquery_html_helpersHtml::unixSeparator().$identifier.magixcjquery_html_helpersHtml::unixSeparator().$date->format('Y-m-d').magixcjquery_html_helpersHtml::unixSeparator().$title.$ext));
		$this->writer->startElement('content');
		$this->writer->writeAttribute('type','html');
		$this->writer->text(magixcjquery_filter_var::escapeHTML($content));
		$this->writer->endElement();
		$this->writer->endElement();
		//$this->writer->endElement();
	}
	/**
	 * End Parent element
	 * @return end 
	 */
	function endWriteRSS(){
		$this->writer->endElement();
		$this->writer->endElement();
	}
	function iniXmlRssReader(){
		$xml = new XMLReader();
		$xml->open(magixcjquery_html_helpersHtml::getUrl().'/rss.xml', "UTF-8");
			/*$value = '<item>';
			while ($xml->read())
			{
				$value .= $xml->value;
			}
			$value .= '</item>';*/
		$value = $xml->read();
		$xml->close(); 
		return $value;
	}
}