<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * 
 * Magix XML
 * 
 * @author Gérits Aurélien
 * @access public
 * @copyright clashdesign
 * @version 0.1
 * @package Singleton XML
 *
 */
class magixcjquery_xml_xml{
	/**
	  *
	  * @var XML
	  * @access private
	  */
	public $serv = null;
	public $xmlWriter = null;
	 /**
	* @var Singleton
	* @access private
	* @static
	*/
	private static $_instance = null;
	function __construct() {
		$this->serv = $_SERVER['DOCUMENT_ROOT'];
		$this->xmlWriter = new XMLWriter();
	}
/**
	 * W3C date Format
	 * @param $str
	 * @return void
	 */
	function isW3CDate($str) {
		$stamp = strtotime( $str );
		  if (!is_numeric($stamp))
		  {
		     return false;
		  }
		  $month = date( 'm', $stamp );
		  $day   = date( 'd', $stamp );
		  $year  = date( 'Y', $stamp );
		 
		  if (checkdate($month, $day, $year))
		  {
		     return $str;
		  }
		 
		  return false; 
	}
	/* @param void
	* @return xml
	*/
	public static function xmlInstance() {
		if(is_null(self::$_instance)) {
			self::$_instance = new magixcjquery_xml_xml();
		}
		return self::$_instance;
	}
	/**
	 * Create XML File
	 * @param $file (string)
	 * @return void
	 */
	function createFile($file){
		if (!file_exists($this->serv.magixcjquery_html_helpersHtml::unixSeparator().$file)) {
			@umask(0755);
			if(@fopen($this->serv.magixcjquery_html_helpersHtml::unixSeparator().$file,'a+') == true){
				if(@chmod($this->serv.magixcjquery_html_helpersHtml::unixSeparator().$file,0755)){return true;}
			}
		}
	}
	/**
	 * Open File and Create new xmlwriter using source uri for output
	 * @param $file (string)
	 * @return void
	 */
	function openUriXml($file){
		if (file_exists($this->serv.magixcjquery_html_helpersHtml::unixSeparator().$file)) {
			$this->xmlWriter->openUri($this->serv.magixcjquery_html_helpersHtml::unixSeparator().$file);
		}else{
			throw new Exception('not file exist');
		}
	}
	/**
	 * Convert valid date format in W3C
	 * http://www.w3.org/TR/NOTE-datetime
	 * @param $date
	 * @return string
	 */
	function dateIsW3c($date){
		$dateTime = new DateTime($date);
		 return $dateTime->format(DATE_ISO8601);
	}
	/**
	 * Toggle indentation on/off
	 * @param $indent = true/false
	 * @return void
	 */
	function indent($indent=true){
		$this->xmlWriter->setIndent($indent);
	}
	/**
	 * End Parent element
	 * @return void
	 */
	function endElement(){
		$this->xmlWriter->endElement();
	}
}

?>