<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * @link http://www.clashdesign.be
 * @copyright clashdesign.be 2009
 * @author : Gérits Aurélien
 * @abstract DbData
 * @package : dataObject
 * @version 0.1
 * 
 */
 abstract class DbData{
 	/**
 	 * DRIVER SGBD
 	 *
 	 * @var STRING
 	 */
 	protected static $driver = M_DBDRIVER;
	/**
	 * SGBD host
	 *
	 * @var string
	 */
	private static $host = M_DBHOST;
	/**
	 * SGBD Name
	 *
	 * @var string
	 */
	protected static $connStr = M_DBNAME;
	/**
	 * SGBD User
	 *
	 * @var string
	 */
	protected static $user = M_DBUSER;
	/**
	 * SFBD Pass
	 *
	 * @var string
	 */
	protected static $pass = M_DBPASSWORD;
	/**
	 * Load DB INFO HOST AND NAME
	 *
	 * @return string
	 */
	function getDnsData(){
		/*mysql*/
		return self::$driver.':dbname='.self::$connStr.';host='.self::$host;
	}
	/**
	 * Load DbUser
	 *
	 * @return string
	 */
	function getuserData(){
 		
		return self::$user;
		
	}
	/**
	 * Load DbPassword
	 *
	 * @return string
	 */
	function getpassData(){
		
		return self::$pass;
	}
}
/**
 * class extends abstract DbData
 *
 */
class CallDbData extends DbData {
	/**
	 * call data DbName
	 *
	 * @return string
	 */
	function getconnStr(){
		return parent::getDnsData();
	}
	/**
	 * Load DbUser
	 *
	 * @return string
	 */
	function getuser(){
		return parent::getuserData();
	}
	/**
	 * Load DbPassword
	 *
	 * @return string
	 */
	function getpass(){
		return parent::getpassData();
	}
}
class DataObjects extends PDO {	
/**
  * Instance de la classe PDO
  *
  * @var PDO
  * @access private
  */
	private static $PDOInstance = null;
	 /**
  * Instance DataObjects class
  *
  * @var DataObjects
  * @access public
  * @static
  */
	public static $instance = null;
	/**
	 * instance CallDbData
	 * @var getinfo
	 * @access protected
	 */
	protected static $getinfo;
	/**
	 * Executes a prepared statement  
	 * @var execute
	 */
	private $execute; 
	/**
	 * constructor implemente CallData 
	 */
    function __construct () 
    {
    	if (!(self::getInfo() instanceof CallDbData)) {
    		throw new Exception('Invalid instanceof CallDbData');
    	}
    	if (!(self::PDOInstance() instanceof PDO)) {
    		throw new Exception('Invalid instanceof PDO');
    	}
        try 
        {
			//$this->PDOInstance = new PDO($dbInfo->getconnStr(),$dbInfo->getuser(),$dbInfo->getpass());
			self::PDOInstance()->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			//self::PDOInstance()->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,true);
        }
        catch(PDOException $e){
        	print $e->getMessage();
		}
    }
    /**
     * instance singleton self (DataObjects)
     * @access public
     */
    public static function getInstance(){
    	if (!isset(self::$instance)){
    		if(is_null(self::$instance)){
				self::$instance = new DataObjects();
			}
      	}
		return self::$instance;
    }
	/**
     * instance singleton self (CallDbData)
     * @access protected
     */
    protected static function getInfo(){
    	if (!isset(self::$getinfo)){
    		if(is_null(self::$getinfo)){
				self::$getinfo = new CallDbData();
			}
      	}
		return self::$getinfo;
    }
	/**
     * instance singleton self (PDO)
     * @access protected
     */
    protected static function PDOInstance(){
    	if (!isset(self::$PDOInstance)){
    		if(is_null(self::$PDOInstance)){
				self::$PDOInstance = new PDO(self::getInfo()->getconnStr(),self::getInfo()->getuser(),self::getInfo()->getpass());
			}
      	}
		return self::$PDOInstance;
    }
     /**
      *  Executes an SQL statement, returning a result set as a PDOStatement object
      *
      * @param request $query
      * @return void
      */
	public function query($query)
	{
		return self::PDOInstance()->query($query);
	}
	/**
	 * Set the default mode for setFetchMode
	 *  Set an attribute 
	 * @return void
	 */
	protected function setMode($mode){
		$fetch = array(
			'assoc' => PDO::FETCH_ASSOC,
			'class' => PDO::FETCH_CLASS,
			'column'=> PDO::FETCH_NUM
		);
		foreach ($fetch as $key){
			$fetchmode = $key[$mode];
		}
		return $fetchmode;
	}
	/**
	 * Sets an attribute on the database handle. 
	 * @param array $attributes
	 */
	public function settingOptions($attributes=array()){
		if(is_array($attributes) && $attributes != null){
			return self::PDOInstance()->setAttribute($attributes);
		}
	}
	/**
	 * Retrieve a database connection attribute 
	 * @param array $attributes
	 * @param void $dump
	 */
	public function getOptions($attributes=array(),$dump=false){
		if(is_array($attributes) && $attributes != null){
			return self::PDOInstance()->getAttribute($attributes);
			if($dump == true){
				foreach ($attributes as $val) {
				    print self::PDOInstance()->getAttribute(constant("PDO::ATTR_$val")). "\n";
				}
			}
		}
	}
	/**
	 *  Prepares a statement for execution and returns a statement object 
	 *
	 * @param request containt $sql
	 * @return void
	 */
	public function prepare($sql){
		return self::PDOInstance()->prepare($sql);
	}
	/**
	 *  Initiates a beginTransaction 
	 *
	 * @param void $sql
	 * @return void
	 */
	public function beginTransaction(){
		return self::PDOInstance()->beginTransaction();
	}
	/**
	 * instance exec
	 *
	 * @param void $sql
	 */
	public function exec($sql){
		self::PDOInstance()->exec($sql);
	}
	/**
	 * instance commit
	 *
	 */
	public function commit(){
		self::PDOInstance()->commit();
	}
	/**
	 * instance rollback
	 *
	 */
	public function rollback(){
		self::PDOInstance()->rollBack();
	}
	/**
	 * instance fetchColumn
	 *
	 */
	public function columnCount(){
		return self::PDOInstance()->columnCount();
	}
	/**
	 * instance fetchColumn
	 *
	 */
	public function fetchColumn($column){
		return self::PDOInstance()->fetchColumn($column);
	}
	/**
	 * Return an array of available PDO drivers 
	 * @return array(void)
	 */
	public function availableDrivers(){
		return self::PDOInstance()->getAvailableDrivers();
	}
	/**
	* Returns the ID of the last inserted row or sequence value 
	*/
	public function lastInsertId(){
		return self::PDOInstance()->lastInsertId();
	}
	/**
	 * Quotes a string for use in a query. 
	 * @param string $string
	 */
	public function quote($string){
		return self::PDOInstance()->quote($string);
	}
	/**
	 * returns an array containing one of the remaining rows in the result set
	 *
	 * @param request $sql
	 * @param int $mode
	 * @return void
	 */
	public function fetch($sql,$execute=false,$mode,$debugParams){
		try{
			$prepare = $this->prepare($sql);
			$prepare->setFetchMode($this->setMode($mode));
			//$prepare->execute();
			$execute ? $prepare->execute($execute) : $prepare->execute();
			$debugParams?$prepare->debugDumpParams():'';
		    $result = $prepare->fetch();
		    $prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){

                	print $e->getMessage(). $e->getLine()."<br />";
                	exit();
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
            }
		return $result;
	}
	/**
	 * returns an array containing all of the remaining rows in the result set
	 *
	 * @param request $sql
	 * @param array $execute
	 * @param int $mode
	 * @return array
	 */
	public function fetchAll($sql,$execute=false,$mode,$debugParams){
		try{
			$prepare = $this->prepare($sql);
			$prepare->setFetchMode($this->setMode($mode));
			$execute ? $prepare->execute($execute) : $prepare->execute();
			$debugParams?$prepare->debugDumpParams():'';
		    $result = $prepare->fetchAll();
		    $prepare->closeCursor();
		    
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
            }
		return $result;
	}
	/**
	 * Execute a prepared statement with an array of insert values
	 *
	 * @param request $sql
	 * @param array $execute
	 */
	public function InsertValue($sql,$execute,$debugParams){
		try{
		$prepare = $this->prepare($sql);
		$prepare->execute($execute);
		$debugParams?$prepare->debugDumpParams():'';
		$prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
          }
	}
	/**
	 * Execute a prepared statement with an array of update values
	 *
	 * @param request $sql
	 * @param array $execute
	 */
	public function UpdateValue($sql,$execute){
		try{
		$prepare = $this->prepare($sql);
		$prepare->execute($execute);
		$prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
          }
	}
	/**
	 * Execute a prepared statement with an array of delete values
	 *
	 * @param request $sql
	 * @param array $execute
	 */
	public function DelValue($sql,$execute){
		try{
		$prepare = $this->prepare($sql);
		$prepare->execute($execute);
		$prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
          }
	}
	/**
	 * function insert transaction exec
	 *
	 * @param void $sql
	 */
	public function InsertTransaction($sql){
		try{
			$this->beginTransaction();
			foreach ($sql as $key){
				$this->exec($key);
			}
			self::commit();
		}catch(Exception $e){
			self::rollback();
                if (M_LOG == 'log') {
	                 if (M_TMP_DIR != null) {
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
         }	
	}
	/**
	 * select DB column
	 *
	 * @param void $sql
	 * @param string $column
	 */
	public function selectFetchColumn($sql,$column,$debugParams){
		try{
			$prepare = $this->prepare($sql);
			$prepare->execute();
			$debugParams?$prepare->debugDumpParams():'';
		    $result = $prepare->fetchColumn($column);
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
            }
		return $result;
	}
	/**
	 * select DB column
	 *
	 * @param void $sql
	 * @param string $column
	 */
	public function columnCountAll($sql,$debugParams){
		try{
			$prepare = $this->prepare($sql);
			$prepare->execute();
			$debugParams?$prepare->debugDumpParams():'';
			$result = $prepare->columnCount();
			 
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
            }
		return $result;
	}
	/**
	 * function Optimize single table
	 *
	 * @param void $table
	 */
	public function singleOptimizeTable($table){
		try{
			$prepare = $this->prepare('OPTIMIZE TABLE '.$table);
			$result = $prepare->execute();
			$prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{	
               exit("Error has database, debug with log");
             }
         }
		return $result;
	}
	/**
	 * function Optimize single table
	 *
	 * @param void $table
	 */
	public function multipleOptimizeTable($table){
		try{
			$result = null;
			foreach ($table as $tKey){
				$prepare = $this->prepare('OPTIMIZE TABLE '.$tKey);
				$result .= $prepare->execute();
				$prepare->closeCursor();
			}
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){
                	
                	print $e->getMessage(). $e->getLine();
                	exit();
                	
                }else{	
               exit("Error has database, debug with log");
             }
         }
         return $result;
	}
	/**
	 * Create simple table
	 *
	 * @param request $sql
	 * @param void $debugParams
	 * 
	 */
	public function createTable($sql,$debugParams){
		try{
			$prepare = $this->prepare($sql);
			//$prepare->setFetchMode($this->setMode($mode));
			$prepare->execute();
			$debugParams?$prepare->debugDumpParams():'';
		    $prepare->closeCursor();
		}catch(Exception $e){
                if (M_LOG == 'log') {
                	
	                 if (M_TMP_DIR != null) {
	                 	
	                 	$log = magixcjquery_error_log::getLog();
	                 	$log->logfile = $_SERVER['DOCUMENT_ROOT'].M_TMP_DIR;
	                 	$log->write('An error has occured', $e->getMessage(), $e->getLine());
	                 	exit("Error has database, view log file");
	                 	
	                 }else{
	                 	die('error path tmp dir');
	                 }
	 				 
                }elseif(M_LOG == 'debug'){

                	print $e->getMessage(). $e->getLine()."<br />";
                	exit();
                }else{
                	
                	exit("Error has database, debug with log");
                	
                }
            }
	}
	/**
	 * delete statique methode clone
	 */
	private function __clone() {
	    throw new Exception('cloning is not allowed');
	}
}
    ?>