<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * interface Layer for magixLayer
 *
 */
interface Layer{
	/**
	 * simple selection of all row
	 *
	 * @param void $sql
	 * @param array($execute)
	 * @param void $mode
	 */
	function select($sql,$execute=false,$mode = 'assoc',$debugParams = false);
	/**
	 * simple selection of one row
	 *
	 * @param void $sql
	 * @param void $mode
	 */
	function selectOne($sql,$execute=false,$mode = 'assoc',$debugParams = false);
	/**
	 * 	insertion of data in SGBD
	 *
	 * @param void $sql
	 * @param array() $execute
	 */
	function insert($sql,$execute,$debugParams = false);
	/**
	 * update of data in SGBD
	 *
	 * @param void $sql
	 * @param array() $execute
	 */
	function update($sql,$execute);
	/**
	 * delete data in SGBD
	 *
	 * @param void $sql
	 * @param array() $execute
	 */
	function delete($sql,$execute);
	/**
	 * insert, delete, update data in SGBD
	 * ##### NO SELECT #####
	 *
	 * @param void $sql
	 */
	function transaction($sql=array());
	/**
	 * select DB column
	 *
	 * @param void $sql
	 * @param string $column
	 */
	function selectColumn($sql, $column = 0,$debugParams=false);
	/**
	 * count column in DB
	 *
	 * @param void $sql
	 */
	function columnCount($sql,$debugParams=false);
	/**
	 * function drivers
	 * Return an array of available PDO drivers 
	 * @return array(void)
	 */
	function drivers();
	/**
	 * function lastInsert
	 * Returns the ID of the last inserted row or sequence value 
	 */
	function lastInsert();
	/**
	 * Quotes a string for use in a query. 
	 * @param string $string
	 */
	function escape_string($string);
	/**
	 * function Optimize single table
	 *
	 * @param void $table
	 */
	function singleOptimize($table);
	/**
	 * function Optimize mulitple table
	 *
	 * @param void $table
	 */
	function multipleOptimize($table);
	/**
	 * Create table 
	 * @param $string
	 */
	function createTable($sql,$debugParams=false);
}
?>