<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------

require('class.DataObjects.php');
require('interface.Layer.php');
class magixcjquery_magixdb_layer implements Layer {
	/**
	 * protected instance DataObjects
	 * @var $instance
	 */
	protected static $instance;
	/**
	 * instance DataObjects
	 *
	 * @var dataObjects
	 */
	//public $dataobject;
	/**
	 * function construct class
	 *
	 */
	protected function iDataObject(){
        if (!isset(self::$instance))
      {
         self::$instance = new DataObjects();
      }
    	return self::$instance;
	}
	/**
	 * function select Request
	 *
	 * @param request $sql
	 * @param array $execute
	 * @param int $mode
	 * @return array
	 */
	function select($sql,$execute=false,$mode = 'assoc',$debugParams = false){
		return self::iDataObject()->getInstance()->fetchAll($sql,$execute,$mode,$debugParams);
	}
	/**
	 * function selectOne Request
	 *
	 * @param request $sql
	 * @param int $mode
	 * @return array
	 */
	function selectOne($sql,$execute=false,$mode = 'assoc',$debugParams = false){
		return self::iDataObject()->getInstance()->fetch($sql,$execute,$mode,$debugParams);
	}
	/**
	 * function insert value with array()
	 *
	 * @param string $sql
	 * @param array() $execute
	 */
	function insert($sql,$execute,$debugParams = false){
		self::iDataObject()->getInstance()->insertValue($sql,$execute,$debugParams);
	}
	/**
	 * function update value with array()
	 *
	 * @param string $sql
	 * @param array() $execute
	 */
	function update($sql,$execute){
		self::iDataObject()->getInstance()->updateValue($sql,$execute);
	}
	/**
	 * function delete value with array()
	 *
	 * @param string $sql
	 * @param array() $execute
	 */
	function delete($sql,$execute){
		self::iDataObject()->getInstance()->delValue($sql,$execute);
	}
	/**
	 * function transaction
	 *
	 * @param void $sql
	 */
	function transaction($sql=array()){
		self::iDataObject()->getInstance()->InsertTransaction($sql);
	}
	/**
	 * select DB column
	 *
	 * @param void $sql
	 * @param string $column
	 */
	function selectColumn($sql, $column = 0,$debugParams=false){
		return self::iDataObject()->getInstance()->selectFetchColumn($sql,$column,$debugParams);
	}
	/**
	 * Count column in DB
	 *
	 * @param void $sql
	 */
	function columnCount($sql,$debugParams=false){
		return self::iDataObject()->getInstance()->columnCountAll($sql,$debugParams);
	}
	/**
	 * function Optimize single table
	 *
	 * @param void $table
	 */
	function singleOptimize($table){
		self::iDataObject()->getInstance()->singleOptimizeTable($table);
	}
	/**
	 * function Optimize mulitple table
	 *
	 * @param void $table
	 */
	function multipleOptimize($table){
		self::iDataObject()->getInstance()->multipleOptimizeTable($table);
	}
	/**
	 * function drivers
	 * Return an array of available PDO drivers 
	 * @return array(void)
	 */
	function drivers(){
		self::iDataObject()->getInstance()->availableDrivers();
	}
	/**
	 * function lastInsert
	 * Returns the ID of the last inserted row or sequence value 
	 */
	function lastInsert(){
		return self::iDataObject()->getInstance()->lastInsertId();
	}
	/**
	 * Quotes a string for use in a query. 
	 * @param $string
	 */
	function escape_string($string){
		return self::iDataObject()->getInstance()->quote($string);
	}
	/**
	 * Create table 
	 * @param $string
	 */
	function createTable($sql,$debugParams=false){
		return self::iDataObject()->getInstance()->createTable($sql,$debugParams=false);
	}
}
?>