<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * Extends jQuery
 * plugins jQuery RSS READER
 *
 */
class magixcjquery_jquery_plugins_rssReader{
	/**
	 * function loading flux rss
	 *
	 * @param string $geturl
	 */
	function getLoadXml($geturl){
		if(@fopen($geturl,"r")){
			header('content-type: application/xml');
			print file_get_contents($geturl);
		}else{
			header('content-type: application/xml');
			print '<?xml version="1.0" encoding="UTF-8"?>
			<!--Generated by magixcjQuery Framework-->
			<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/">
			 <channel>
			  <item>
			   <title>Loading error</title>
			   <pubDate>'.date('Y-m-d').'</pubDate>
			   <link>'.magixcjquery_html_helpersHtml::getUrl().'</link>
			   <description><![CDATA[<p>file no exist</p>]]></description>
			  </item>
			 </channel>
			</rss>';
		}
	}
	/**
	 * function create jQuery RSS READER
	 *
	 * @param string $nid
	 * @param string $target
	 * @param string $items
	 * @param string $Maxlength
	 * @param string $loadingImg
	 * @param string $end
	 * @return string
	 */
	public static function getRss($nid=true, $target, $items, $Maxlength, $loadingImg , $end=true){
		$rss = $nid ? magixcjquery_jquery_magixcjQuery::getjQueryHandling().'('.$nid.')' : '';
	    $rss .= '.rssReader({';
	    $rss .= $target ? 'targeturl: "'.$target.'"' : '"http://www.clashdesign.net/blog/index.php/feed/rss2"';
	    $rss .= ',';
	    $rss .= $items ? 'items :' .$items : '5';
	    $rss .= ',';
	    $rss .= $Maxlength ? 'Maxlength :' . $Maxlength : '80';
	    $rss .= ',';
	    $rss .= $loadingImg ? 'loadingImg : "'.$loadingImg.'"' :'"img/35-1.gif"';
	    $rss .= '})';
		$rss .= $end ? ';' : '';
		return $rss;
	}
}
?>