<?php
# -- BEGIN LICENSE BLOCK ----------------------------------
#
# This file is part of magix cjQuery.
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# Magix cjQuery is a library written in PHP 5.
# It can work with a layer of abstraction, to validate data, handle jQuery code in PHP.
# Copyright (C)Magix cjQuery 2009 Gerits Aurelien
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# -- END LICENSE BLOCK -----------------------------------
/**
 * 
 * Magix cjQuery
 * 
 * @author Gérits Aurélien
 * @access public
 * @copyright clashdesign
 * @version 0.1
 * @package URL
 *
 */
class magixcjquery_url_clean{
	/**
	 * function clean string 
	 * clean accent
	 * clean uppercase
	 * replace | for -
	 *
	 * @param string $params
	 * @return string
	 */
	/*function rplMagixString($params){
	        $params = magixConvertText::downTextCase($params);
			$params = str_replace("( |')", "-", $params);
			$accent = array('&','â','à','é','è','ê','î','ô','û','ç');
			$unaccented = array('and','a','a','e','e','e','i','o','u','c');
			$params = str_replace($accent, $unaccented, $params);
			$params = eregi_replace("[^a-z0-9]","-",$params);
			$params = eregi_replace("(^(_)*|(_)*$)","",$params);
			$params = eregi_replace("(.){2,3}","",$params);
		return $params;
	}*/
	function rplMagixString($str,$nopoint=false){
	/**Clean accent*/
	$Caracs = array("¥" => "Y", "µ" => "u", "À" => "A", "Á" => "A",
                "Â" => "A", "Ã" => "A", "Ä" => "A", "Å" => "A",
                "Æ" => "A", "Ç" => "C", "È" => "E", "É" => "E",
                "Ê" => "E", "Ë" => "E", "Ì" => "I", "Í" => "I",
                "Î" => "I", "Ï" => "I", "Ð" => "D", "Ñ" => "N",
                "Ò" => "O", "Ó" => "O", "Ô" => "O", "Õ" => "O",
                "Ö" => "O", "Ø" => "O", "Ù" => "U", "Ú" => "U",
                "Û" => "U", "Ü" => "U", "Ý" => "Y", "ß" => "s",
                "à" => "a", "á" => "a", "â" => "a", "ã" => "a",
                "ä" => "a", "å" => "a", "æ" => "a", "ç" => "c",
                "è" => "e", "é" => "e", "ê" => "e", "ë" => "e",
                "ì" => "i", "í" => "i", "î" => "i", "ï" => "i",
                "ð" => "o", "ñ" => "n", "ò" => "o", "ó" => "o",
                "ô" => "o", "õ" => "o", "ö" => "o", "ø" => "o",
                "ù" => "u", "ú" => "u", "û" => "u", "ü" => "u",
                "ý" => "y", "ÿ" => "y");
     $str = strtr("$str", $Caracs);
     $str = magixcjquery_filter_var::trimText($str);
     /*replace & => $amp (w3c convert)*/
	 $str = str_replace('&','&amp',$str);
	 if($nopoint){
	 	$str = str_replace('.','',$str);
	 }
	 /* stripcslashes backslash */
	 $str = magixcjquery_filter_var::cleanQuote($str);
	 /*replace blank and special caractère*/
	 $cSpec = array("@'@i",'@[[:blank:]]@i','[\?]','[\#]','[\@]');
	 $rSpec = array ('-','-',"","",""); 
	 /*Removes the indent if end of string*/  
	 $str = rtrim(preg_replace($cSpec,$rSpec,$str),"-");
	 /*Convert UTF8 encode*/
	 $str = magixcjquery_string_convert::decode_utf8($str);
	 /*Convert lower case*/
	 $str = magixcjquery_string_convert::downTextCase($str);
     return $str;  
	}
}